# About

3DPrinterOS is the 3D printer control software. This code is client part.
The server side is https://cloud.3dprinteros.com.

Here is the list of some supported printers(and printer board firmwares):
Marlin, Repetier, Grbl, RepRap firmware based(Prusa, Lulzbot, AirWolf and many others)
Makerbot 2gen
Makerbot 5gen
Smoothieware based
FlashForge Dreamer
Bosch Dremel
MBot 3D Printer

### Features:
- Autodetection and autoconnection - no need to select port or baudrate, just printer type in some cases
- Multiprinting - single host for can be used to control several printers
- Remote control of a 3D printer using the web site. The web site provides slicing, model fixing and other stuff that you could find useful - all in one place
- Web camera support. As well as printers, you could use multiple cameras, but be warn that this requires high performance CPU

# Getting 3DPrinterOS Client

The install packages for GNU/Linux, MS Windows, MacOS X at  https://cloud.3dprinteros.com
You can also download an image for Raspberry Pi there.
# Python version
3DPrinterOS client requires Python3.7+
# Running from source
All needed libraries for MS Windows and Mac OS X are included (to use included libraries under MS Windows, you should run 32 bit version python).

For GNU/Linux you should install following libraries:
- opencv
- libusb1.0
- python dependencies listed in requirements.txt 
  (pip3 install -r requirements.txt)

Under MS Windows libusb1.0 and admin rights are required to read/write serial port and proper support of all printers.

Under GNU/Linux you can create a file named 3dprinter.rules in `/etc/udev/rules.d/` containing following:
```
SUBSYSTEM=="usb", ENV{DEVTYPE}=="usb_device", MODE="0664", GROUP="usbusers"
```
Then execute following to activate the rules:
```
useradd -G usbusers $USER
useradd -G tty uucp $USER
useradd -G dailout $USER
udevadm control --reload-rules
```

#### Launching:
```
python launcher.py
```
(or ```python3``` on some distros)
(ofcoarse on MS Windows you need python added to PATH to run python from any folder)

# License
>Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019. Built in San Francisco.

>This software is distributed under commercial non-GPL license for personal, educational,
corporate or any other use. The software as a whole or any parts of that are prohibited
for distribution and/or use without obtaining license from 3D Control Systems, Inc.

>If you do not have the license to use this software, please delete all software files
immediately and contact sales to obtain the license: sales@3dprinteros.com.
If you are unsure about the licensing please contact directly our sales: sales@3dprinteros.com.
