import http_scanner


class HTTPDremelDetector(http_scanner.HTTPDetector):

    PORT = 80
    PATH = "/command"
    RESPONSE_FIELD_NAME = 'SN'
    METHOD = "POST"
    BODY = "GETPRINTERINFO=1"
    HEADERS = {"Content-Type": "application/x-www-form-urlencoded"}
    FORCE_PROFILE_ALIAS = 'DREMEL3D45'


if __name__ == '__main__':
    import logging
    from pprint import pprint
    #logging.basicConfig(level=logging.DEBUG)
    logging.basicConfig(level=logging.INFO)

    dht = HTTPDremelDetector()
    dht.detect()
    print('Detected:')
    pprint(dht.discovered_printers)
