import logging
import sys

import config
import platforms

if platforms.get_platform() == 'rpi':
    try: 
        from periphery_gpio_interface import PeripheryGPIOInterface as GPIOInterface
    except (ImportError, RuntimeError) as e1:
        logger = logging.getLogger(__name__)
        logger.warning('Error on load of GPIO interface backend(python-periphery):' + str(e1))
        try:
            logger.info('Attempting import of legacy GPIO backend(RPiGPIO)')
            from rpigpio_interface import RPiGPIOInterface as GPIOInterface
        except (ImportError, RuntimeError) as e2:
            logger.error('No GPIO backend found, but gpio setting is enabled:' + str(e2))

if 'GPIOInterface' not in sys.modules:
    # GPIO disabled, will act as a dummy 
    from base_gpio_interface import BaseGPIOInterface as GPIOInterface
    try:
        import gpio_map
        self.logger.info('machine model: ' + str(gpio_map.gpiomap.get_machine_model_name()))
    except:
        pass
