import os.path

UNDERVOLTAGE_FILE = '/sys/class/hwmon/hwmon1/in0_lcrit_alarm'

def undervoltage_detected():
    try:
        if os.path.exists(UNDERVOLTAGE_FILE):
            with open(UNDERVOLTAGE_FILE) as f:
                if int(f.read()) == 1:
                    return True
    except (OSError, TypeError, ValueError):
        pass
    return False

if __name__ == "__main__":
    if undervoltage_detected():
        print('Warning! Under-voltage detected')
    else:
        print('No under-voltage detected')
