#!/bin/bash

# kate: indent-pasted-text true; remove-trailing-spaces all; replace-tabs true; replace-tabs-save true; syntax Bash; word-wrap-column 200;


RED="\e[31m"
GREEN="\e[32m"
YELLOW="\e[33m"
ENDCOLOR="\e[0m"
SPACER="\t\t"

#for var in "$@"
#do
#    if  [[ $var == "--plain" ]]; then
#    fi
#done

while [[ $# -gt 0 ]]; do
    case $1 in
        -o|--output)
            OUTPUT_PATH="$2"
            shift # past argument
            shift # past value
            ;;
        -p|--plain)
            RED=""
            GREEN=""
            YELLOW=""
            ENDCOLOR=""
            SPACER="\n"
            shift # past argument
            ;;
        -f|--fast)
            FAST=true
            shift # past argument
            ;;
    esac
done

function run {
    echo -e "$(uname -srm)  $(python3 --version)  3DPrinterOS Client $(python3 -c "import version; print(version.version, version.branch, version.build)")"

    echo -n -e 'Board model:\t\t'
    if [[ -n $(dmesg 2>/dev/null | head -n10 | grep 'Machine model' | sed -r 's/(^.+)(Machine model:\s+)(.+)/\3/g') ]] ; then
        echo -e -n "$(dmesg 2>/dev/null | head -n10 | grep 'Machine model' | sed -r 's/(^.+)(Machine model:\s+)(.+)/\3/g')"
        if [[ -n $(dmesg | grep -i "under-voltage detected") ]] ; then
            echo -n -e " ${RED}under-voltage${ENDCOLOR}"
        fi
        if vcgencmd measure_temp &> /dev/null; then
            TEMPERATURE=$(vcgencmd measure_temp | sed -r 's/^([a-z]+=)//g')
            if [[ $(echo "$TEMPERATURE" | sed -r 's/^([0-9]+)(\..+)/\1/g') -gt 65 ]] ; then
                echo -e "${RED} $TEMPERATURE${ENDCOLOR}"
            else
                echo -e "${GREEN} $TEMPERATURE${ENDCOLOR}"
            fi
        fi
    else
        echo -e "${YELLOW}Unknown board${ENDCOLOR}\t"
    fi

    echo -n -e 'SD:\t\t\t'
    if [ $(df -m --output='avail' / | tail -n1) -gt 2048 ] ; then
        echo -e -n "${GREEN}$(df -m --output='avail' / | tail -n1 | xargs)${ENDCOLOR} / "
    else
        echo -e -n "${RED}$(df -m --output='avail' / | tail -n1 | xargs)${ENDCOLOR} / "
    fi
    echo -e -n "$(df -m --output='size' / | tail -n1 | xargs) MB"
    if [ $(df -m --output='size' / | tail -n1 | xargs) -gt 99999 ] ; then
        echo -e -n "\t\t"
    else
        echo -e -n "\t\t\t"
    fi

    echo -n -e 'Ping to cloud:\t\t'
    if [ -z $FAST ]
    then
        if ping cli-cloud.3dprinteros.com -c 1 &> /dev/null; then
            echo -e "${GREEN}Yes${ENDCOLOR}"
        else
            echo -e "${RED}No${ENDCOLOR}"
        fi
    else
        echo -e "${YELLOW}Skip${ENDCOLOR}"
    fi


    echo -n -e 'RAM:\t\t\t'
    if [ $(expr $(sed -n '/^MemFree:/ s/[^0-9]//gp' /proc/meminfo) / 1024) -gt 1024 ] ; then
        echo -e -n "${GREEN}$(expr $(sed -n '/^MemFree:/ s/[^0-9]//gp' /proc/meminfo) / 1024)${ENDCOLOR} / "
    else
        echo -e -n "${RED}$(expr $(sed -n '/^MemFree:/ s/[^0-9]//gp' /proc/meminfo) / 1024)${ENDCOLOR} / "
    fi
    echo -e -n "$(expr $(sed -n '/^MemTotal:/ s/[^0-9]//gp' /proc/meminfo) / 1024) MB"
    if [ $(expr $(sed -n '/^MemFree:/ s/[^0-9]//gp' /proc/meminfo) / 1024) -gt 9999 ] ; then
    echo -e -n "\t\t"
    else
    echo -e -n "\t\t\t"
    fi

    echo -n -e 'Cloud login:\t\t'
    if [ -z $FAST ]
    then
        echo -e -n "$(python3 user_login.py --login)"
        if [ $(python3 user_login.py --auth) == "success" ] ; then
            echo -e " ${GREEN}success${ENDCOLOR}"
        else
            echo -e " ${RED}$(python3 user_login.py --auth)${ENDCOLOR}"
        fi
    else
        echo -e "${YELLOW}Skip${ENDCOLOR}"
    fi

    echo -n -e 'Swap:\t\t\t'
    if [ $(sed -n '/^SwapTotal:/ s/[^0-9]//gp' /proc/meminfo) -eq 0 ] ; then
        echo -n -e "off\t"
    else
        if [ $(expr $(sed -n '/^SwapFree:/ s/[^0-9]//gp' /proc/meminfo) / 1024) -gt 1024 ] ; then
            echo -e -n "${GREEN}$(expr $(sed -n '/^SwapFree:/ s/[^0-9]//gp' /proc/meminfo) / 1024)${ENDCOLOR} / "
        else
            echo -e -n "${RED}$(expr $(sed -n '/^SwapFree:/ s/[^0-9]//gp' /proc/meminfo) / 1024)${ENDCOLOR} / "
        fi
        echo -e -n "$(expr $(sed -n '/^SwapTotal:/ s/[^0-9]//gp' /proc/meminfo) / 1024) MB"
    fi

    echo -n -e '\t\t\tHost ID:\t\t'
    if [ -z $FAST ]
    then
        python3 http_client.py --id
    else
        echo -e "${YELLOW}Skip${ENDCOLOR}"
    fi

    echo -n -e 'Ping to 8.8.8.8:\t'
    if ping 8.8.8.8 -c 1 &> /dev/null; then
        echo -e -n "${GREEN}Yes${ENDCOLOR}\t"
    else
        echo -e -n "${RED}No${ENDCOLOR}\t"
    fi

    echo -n -e '\t\t\tNative picamera:\t'
    if python3 -c "import picamera" &> /dev/null; then
        echo -e "${GREEN}Installed${ENDCOLOR}"
    else
        echo -e "${RED}Not installed${ENDCOLOR}"
    fi

    echo -n -e 'PySerial:\t\t'
    if python3 -c "import serial" &> /dev/null; then
        echo -e -n "${GREEN}Installed${ENDCOLOR}"
    else
        echo -e -n "${RED}Not installed${ENDCOLOR}"
    fi

    echo -n -e '\t\t\tOpenCV:\t\t\t'
    if python3 -c "import cv2" &> /dev/null; then
        echo -e "${GREEN}Installed${ENDCOLOR}"
    else
        echo -e "${RED}Not installed${ENDCOLOR}"
    fi

    echo -n -e 'Cloud HTTPS:\t\t'
    if [ -z $FAST ]
    then
        if curl https://cli-cloud.3dprinteros.com/noauth/get_timestamps &> /dev/null; then
            echo -e "${GREEN}Yes${ENDCOLOR}"
        else
            echo -e "${RED}No${ENDCOLOR}"
        fi
    else
        echo -e "${YELLOW}Skip${ENDCOLOR}"
    fi
}

if [ -z "$OUTPUT_PATH" ];
then
    run
else
    run > $OUTPUT_PATH
fi
