"""
for asyncio.open_connection(), we do NOT use ProactorEventLoop for Windows.
Hence the use of "use_run"
"""
import os
import sys
import asyncio


def runner(fun, *args):
    """
    Generic asyncio.run() equivalent for Python >= 3.5
    """

    if sys.version_info >= (3, 7) and not (os.name == 'nt' and sys.version_info[0] == 3 and sys.version_info[1] == 9):
        result = asyncio.run(fun(*args))
    else:  # 3.8 windows, 3.6, 3.5
        loop = asyncio.SelectorEventLoop()
        result = loop.run_until_complete(fun(*args))
        loop.close()

    return result
