import sys

def decommentify_file(filepath):
    text_without_comments = ""
    with open(filepath) as f:
        for line in f:
            cleaned_line = decommentify_line(line)
            if cleaned_line:
                text_without_comments += cleaned_line + "\n"
    with open(filepath, "w") as f:
        f.write(text_without_comments)

def decommentify_line(line):
    return line.split(";")[0].strip()

if __name__ == "__main__":
    if len(sys.argv) > 1:
        filename = sys.argv[1]
        decommentify_file(filename)
