// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import QtQuick.Controls 2.4
import AppControls 1.0
import AppDialogs 1.0
import AppStyle 1.0
import AppViews 1.0
import "constants.js" as Constants

AbstactPage {
    id: accountInfoView
    property real btnWidth: AppStyle.theme.settingsMenuItemWidth
    property real btnHeight: AppStyle.theme.settingsMenuItemHeight

    pageBody: Item {
        anchors.fill: parent

        Grid {
            id: firstBtnGrid
            anchors.centerIn: parent
            rows: 3
            columns: 3
            columnSpacing: 30
            rowSpacing: 30

            TextButton {
                width: btnWidth
                height: btnHeight
                text: coreModel.cameraState ? qsTr("Disable camera") : qsTr("Enable Camera")
                onClicked: {
                    if (coreModel.cameraState) {
                        coreModel.disableCamera()
                        return
                    }

                    coreModel.enableCamera()
                }
            }

            TextButton {
                width: btnWidth
                height: btnHeight
                text: qsTr("Reset printer board")
                onClicked: {
                    rootItem.hideSetting()
                    printerModel.resetBoard()
                }
            }

            TextButton {
                width: btnWidth
                height: btnHeight
                text: qsTr("Z-Offset Calibration")
                onClicked: {
                    if (coreModel.state === Constants.States.IDLE || coreModel.state === Constants.States.PRINTING || coreModel.state === Constants.States.PAUSED) {
                        rootItem.pushView("ZOffsetCallibrationView.qml")
                        return
                    }
                    rootItem.showMessageDialog(Constants.MessageTypes.INFO, qsTr("Calibration is only available when printer is in operational state and idle"), "OK")
                }
            }

//            TextButton {
//                width: btnWidth
//                height: btnHeight
//                text: qsTr("Emergency unload all")
//                onClicked: {
//                }
//            }
        }
    }

    footer {
        nextBtnVisible: false
        onBackClicked: {
            rootItem.showHead()
            rootItem.back()
        }
    }
}

