// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import QtGraphicalEffects 1.0

import AppStyle 1.0

/*
  Note:
  Using it will be GPU consuming task as the inner item and mask have to be
  drawn on buffer first and then redrawn on window, so not very good for old mobile
  or weak embedded devices.
*/

Rectangle {
    color: "transparent"
    default property alias itemPlace: rectSource.data
    radius: Math.min(width, height) * 0.25
    border.color: AppStyle.theme.foreground
    border.width: 1

    Rectangle {
        id: maskLayer
        color: "white"
        radius: parent.radius
        smooth: true
        visible: false
        width: rectSource.width
        height: rectSource.height
        anchors.centerIn: parent
        border.color: AppStyle.theme.foreground
        border.width: 2
    }

    Item {
        id: rectSource
        anchors.fill: parent
        layer.enabled: true
        layer.effect: OpacityMask {
            maskSource: maskLayer
        }
    }
}
