// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import QtQuick.Controls 2.4
import AppStyle 1.0

Button {
    id: control
    width: visible
           ? (btnText.paintedWidth > defaultWidth * 0.9 ? btnText.paintedWidth * 1.25 : defaultWidth)
           : 0
    height: 76
    text: qsTr("Next")

    property int backgroundRadius: AppStyle.theme.textBtnBgRadius
    property real defaultWidth: AppStyle.theme.textBtnDefaultWidth
    property bool boldText: AppStyle.theme.textBtnBoldText
    property bool upperCase: AppStyle.theme.textBtnUpperCase
    property real textPixelSize: AppStyle.theme.textBtnTextPixelSize
    property color backgroundColor: AppStyle.theme.textBtnBackgroundColor
    property color pressedColor: AppStyle.theme.textBtnPressedColor
    property color borderColor: AppStyle.theme.textBtnBorderColor
    property color borderPressedColor: AppStyle.theme.textBtnBorderPressedColor
    property color textColor: AppStyle.theme.textColor
    property color textPressedColor: AppStyle.theme.textColorPressed
    property real textRotation: AppStyle.theme.textBtnTextRotation

    contentItem: Item {
        implicitWidth: 155
        implicitHeight: 76

        Text {
            id: btnText
            anchors.fill: parent
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignHCenter
            wrapMode: Text.WordWrap
            text: control.text
            rotation: control.textRotation
            color: control.pressed ? control.textPressedColor : control.textColor
            font {
                pixelSize: control.textPixelSize
                capitalization: control.upperCase ? Font.AllUppercase : Font.MixedCase
                bold: boldText
            }
        }
    }

    background: Rectangle {
        implicitWidth: 155
        implicitHeight: 76
        radius: control.backgroundRadius
        border.width: 1
        border.color: control.pressed ? control.borderPressedColor : control.borderColor
        color: control.pressed ? control.pressedColor : control.backgroundColor
    }

    onClicked: {
        console.info("Clicked: " + control.text)
    }
}
