// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import AppStyle 1.0
import AppControls 1.0


Item {
    id: msgDialogRoot
    width: rootItem.width
    height: rootItem.height
    visible: true
    property color titleColor: AppStyle.theme.foreground
    property string titleText: printerModel.doorOpen
                               ? qsTr("Close the Sliding Doors")
                               : qsTr("Open the Sliding Doors")
    property string msgHead: qsTr("Warning")
    property string msg: printerModel.doorOpen
                         ? qsTr("Please make sure nothing blocks the door movement. Print will resume after the doors are closed.")
                         : qsTr("Opening the doors will pause the printing process and may affect the print quality.")
    property string imgSource: printerModel.doorOpen
                               ? ("../" + AppStyle.theme.imgDir + "close.png")
                               : ("../" + AppStyle.theme.imgDir + "open.png")
    property real defaultBodyHeight: 150
    property real buttonsSectionHeight: 120

    readonly property real maxBodyHeight: rootItem.height - buttonsSectionHeight - titleRect.height
    readonly property real bodyHeight: msgText.paintedHeight > defaultBodyHeight
                                       ? (msgText.paintedHeight > maxBodyHeight ? maxBodyHeight : msgText.paintedHeight)
                                       : defaultBodyHeight

    property real dialogWidth: 550
    property real dialogHeight: bodyHeight + buttonsSectionHeight + titleRect.height
    default property alias buttonsSection: buttonsSectionPlace.data
    property bool hideOnBtnClick: true
    property string yesText: printerModel.doorOpen ? qsTr("Close") : qsTr("Open")
    property string noText: qsTr("Cancel")

    property alias yesAlias: yesBtn
    property alias noAlias: noBtn

    signal yes
    signal no

    MouseArea {
        anchors.fill: parent
    }

    Rectangle {
        id: background
        anchors.fill: parent
        color: "black"
        opacity: 0.5
    }

    Rectangle {
        id: dialogRoot
        width: dialogWidth
        height: dialogHeight
        color: AppStyle.theme.background
        opacity: 1.0
        anchors.centerIn: parent

        Rectangle {
            id: titleRect
            anchors {
                top: dialogRoot.top
                right: dialogRoot.right
                left: dialogRoot.left
                margins: 1
            }

            height: 45
            color: titleColor

            Text {
                id: titleTextItem
                anchors.centerIn: parent
                color: AppStyle.theme.textColor
                font.pixelSize: parent.height * 0.55
                text: titleText
            }
        }

        Item {
            id: winBody
            anchors {
                top: titleRect.bottom
                right: parent.right
                left: parent.left
                bottom: parent.bottom
            }
            height: bodyHeight
//            clip: true

            Column {
                id: contentColumn
                spacing: AppStyle.theme.defaultMargin * 0.2
                anchors {
//                    centerIn: parent
                    top: parent.top
                    topMargin: contentColumn.spacing
                    horizontalCenter: parent.horizontalCenter
                }

                width: parent.width * 0.9

                Text {
                    id: headText
                    text: msgHead
                    width: contentColumn.width
                    horizontalAlignment: Text.AlignHCenter
                    color: AppStyle.theme.textColor
                    wrapMode: Text.WordWrap
                    font {
                        bold: true
                        pixelSize: 30
                    }
                }

                Text {
                    id: msgText
                    text: msg
                    width: contentColumn.width
                    horizontalAlignment: Text.AlignHCenter
                    color: AppStyle.theme.textColor
                    wrapMode: Text.WordWrap
                    font.pixelSize: 19
                }
            }
        }

        Item {
            id: buttonsSectionPlace
            anchors {
                bottom: parent.bottom
                left: parent.left
                right: parent.right
                margins: 30
            }

            height: 70

            Rectangle {
                anchors.fill: parent
                color: AppStyle.theme.background

                TextButton {
                    id: yesBtn
                    text: yesText
                    height: 55
                    anchors {
                        left: parent.left
                        bottom: parent.bottom
                    }

                    onClicked: {
                        msgDialogRoot.yes()

                        if (hideOnBtnClick) {
                            msgDialogRoot.visible = false
                        }
                    }
                }

                Item {
                    height: 102
                    width: doorsImg.width
                    anchors.centerIn: parent
                    anchors.verticalCenterOffset: -5
                    Image {
                        id: doorsImg
                        anchors.centerIn: parent
                        source: imgSource
                        sourceSize.width: 180
                        sourceSize.height: 115
                    }
                }

                TextButton {
                    id: noBtn
                    text: noText
                    height: 55
                    anchors {
                        right: parent.right
                        bottom: parent.bottom
                    }

                    onClicked: {
                        msgDialogRoot.no()
                        if (hideOnBtnClick) {
                            msgDialogRoot.visible = false
                        }
                    }
                }
            }
        }
    }
}
