// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import AppStyle 1.0
import AppControls 1.0
import "../constants.js" as Constants

AbstractMessageDialog {
    id: msgRoot
    anchors.fill: parent
    property string messageType: Constants.MessageTypes.INFO
    property string btnText: qsTr("OK")

    signal okClicked()

    titleColor: switch (messageType) {
                case Constants.MessageTypes.ERROR:
                    return AppStyle.theme.errorTitleBackground
                case Constants.MessageTypes.WARNING:
                    return AppStyle.theme.warningTitleBackgraound
                case Constants.MessageTypes.INFO:
                    return AppStyle.theme.foreground
                default:
                    return AppStyle.theme.foreground
                }

    titleText: switch (messageType) {
               case Constants.MessageTypes.ERROR:
                   return qsTr("Error")
               case Constants.MessageTypes.WARNING:
                   return qsTr("Warning")
               case Constants.MessageTypes.INFO:
                   return qsTr("Info")
               default:
                   return qsTr("Info")
               }

    buttonsSection: TextButton {
        id: okBtn
        text: btnText
        anchors {
            top: parent.top
            bottom: parent.bottom
            horizontalCenter: parent.horizontalCenter
        }

//        borderColor: titleColor
//        pressedColor: titleColor
//        anchors {
//            fill: parent
//        }

        onClicked: {
            msgRoot.visible = false
            okClicked()
        }
    }
}
