import QtQuick 2.0
import AppControls 1.0

QtObject {
    // strings
    property string e0TempText: "E0"
    property string e1TempText: "E1"
    property string bedTempText: "BED"

    property string name: "default"
    property string fontFamily: "Lato Black"
    property string secondFontFamily: "BalooBhai"

    property bool doubleTool: false

    // colors
    property color headColor: "black"
    property color warningTitleBackgraound: "#ffb700"
    property color errorTitleBackground: "#ed0000"
    property color configLineNumberColor: "#b5b5b5"
    property color pressedColor: "#ebebeb"
    property color background: "#222026"
    property color foreground: "#ffb000"
    property color textColor: "white"
    property color textColorPressed: "white"
    property color statusTextColor: textColor
    property color listBorderColor: "#b5b5b5"

    // img
    property string imgDir: "AppStyle/default/img/"
    property string logoImgSource: imgDir + "logo.svg"

    // sizes
    property real headHeight: 60.0
    property real headLogoWidth: 194.0
    property real headLogoHeight: 31.0
    property real headItemHeight: 45.0
    property real headItemStatusTextWidth: 55.0
    property real footerHeight: 76.0
    property real defaultMargin: 50.0
    property real textFieldHeight: 64.0
    property real settingsMenuItemWidth: 160.0
    property real settingsMenuItemHeight: 128.0

    // menus
    property string joystickMenu: "JoystickView.qml"
    property string filamentWizzardMenu: ""
    property int textBtnBgRadius: 10
    property real textBtnDefaultWidth: 155
    property bool textBtnBoldText: true
    property bool textBtnUpperCase: true
    property real textBtnTextPixelSize: 26
    property color textBtnBackgroundColor: "transparent"
    property color textBtnPressedColor: "#00007d"
    property color textBtnBorderColor: AppStyle.theme.foreground
    property color textBtnBorderPressedColor: AppStyle.theme.foreground
    property real textBtnTextRotation: 0
}
