// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import AppStyle 1.0
import AppControls 1.0

Rectangle {
    id: footer
    width: 800
    height: AppStyle.theme.footerHeight
    color: "transparent"

    property string textInfo: ""
    property string nextBtnText: qsTr("Next")
    property string backBtnText: qsTr("Back")
    property bool nextBtnVisible: true
    property bool backBtnVisible: true

    signal backClicked()
    signal nextClicked()

    Row {
        anchors.fill: parent
        spacing: 0

        TextButton {
            id: backButton
            text: backBtnText
            visible: backBtnVisible
            onClicked: backClicked()
        }

        Item {
            id: label
            width: footer.width - backButton.width - nextButton.width
            height: footer.height

            Text {
                id: info
                anchors.fill: parent
                verticalAlignment: Text.AlignVCenter
                horizontalAlignment: Text.AlignHCenter
                text: textInfo
                color: AppStyle.theme.textColor
                font {
                    pixelSize: 28
                }
            }
        }

        TextButton {
            id: nextButton
            text: nextBtnText
            visible: nextBtnVisible
            backgroundColor: "transparent"
            pressedColor: AppStyle.theme.foreground
            onClicked: nextClicked()
        }
    }
}
