import QtQuick 2.7
import QtQuick.Controls 2.4
import AppStyle 1.0

AbstactPage {
    property alias listViewItem: listView
    pageBody: ListView {
        id: listView
        clip: true
        anchors.fill: parent
        currentIndex: -1
        property bool showHead: false
        property bool scrollBarEnabled: listView.contentHeight > listView.height
        property real defaultItemHeight: 64

        ScrollBar.vertical: ScrollBar {
            id: scroll
            policy: ScrollBar.AlwaysOn
            visible: listView.scrollBarEnabled
            parent: listView.parent
            anchors {
                top: parent.top
                left: parent.right
                bottom: parent.bottom
            }

            contentItem: Rectangle {
                implicitWidth: 7
                implicitHeight: 100
                color: scroll.pressed ? AppStyle.theme.pressedColor : AppStyle.theme.foreground
            }
        }
    }
}
