import QtQuick 2.7
import QtQuick.Controls 2.4
import AppControls 1.0
import AppDialogs 1.0
import AppStyle 1.0
import AppViews 1.0
import "constants.js" as Constants

AbstactPage {
    id: settingsView

    property real btnWidth: AppStyle.theme.settingsMenuItemWidth
    property real btnHeight: AppStyle.theme.settingsMenuItemHeight

    ConfirmDialog {
        id: unbindPrinterConfirm
        z: 110
        anchors.centerIn: parent
        visible: false
        titleText: "Warning"
        titleColor: AppStyle.theme.warningTitleBackgraound
        msg: qsTr("This will unbind this printer from your 3DPrinterOS account.\n Warning: ongoing print will be aborted!")
        yesText: qsTr("Unbind")
        noText: qsTr("Cancel")
        onYes: {
            coreModel.unbind()
            //TODO switch to register screen
            rootItem.hideSetting()
        }
    }

    pageBody: Item {
        anchors.fill: parent

        Grid {
            id: settingsGrid
            spacing: AppStyle.theme.defaultMargin * 0.6
            anchors.centerIn: parent
            rows: 3
            columns: 3
            columnSpacing: AppStyle.theme.defaultMargin * 0.6
            rowSpacing: AppStyle.theme.defaultMargin * 0.6

            TextButton {
                width: btnWidth
                height: btnHeight
                text: qsTr("Unbind from cloud")
                onClicked: {
                    if (coreModel.state === Constants.States.PRINTING || coreModel.state === Constants.States.PAUSED) {
                        rootItem.showMessageDialog(Constants.MessageTypes.INFO, qsTr("Please, finish ongoing print before unbinding the printer from the Cloud."), "OK")
                        return
                    }
                    unbindPrinterConfirm.visible = true
                }
            }

            TextButton {
                width: btnWidth
                height: btnHeight
                text: qsTr("Check cloud's queue")
                onClicked: {
                    printerModel.checkCloudsQueue()
                }
            }

            TextButton {
                width: btnWidth
                height: btnHeight
                text: qsTr("Upload logs")
                onClicked: {
                    coreModel.uploadLogs()
                }
            }

            TextButton {
                width: btnWidth
                height: btnHeight
                text: qsTr("Check for updates")
                onClicked: {
                    coreModel.checkForUpdates()
                }
            }
        }
    }

    footer {
        nextBtnVisible: false
        backBtnVisible: !unbindPrinterConfirm.visible
        onBackClicked: {
            rootItem.showHead()
            rootItem.back()
        }
    }
}
