// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import AppViews 1.0

RowAnimText {
    id: glovesWarn
    animSource: "gifs/wearing_gloves.gif"
    infoText: qsTr("Please wear protective gloves for your safety.")

    footer {
        visible: true
        onNextClicked: {
            switch(filamentWizardRoot.wizardType) {
            case FilamentWizard.WizardType.Load:
                filamentWizardRoot.pushView("SelectFilamentSlotPage.qml",
                                            {"descriptionText": qsTr("Select the material to load:")})
                break;
            case FilamentWizard.WizardType.Unload:
                filamentWizardRoot.pushView("SelectFilamentSlotPage.qml",
                                            {"descriptionText": qsTr("Select the material to unload:")})
                break;
            }
        }
    }
}
