// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import AppStyle 1.0
import AppControls 1.0
import AppViews 1.0

RowAnimText {
    id: heatPage
    animSource: "gifs/printed_heating.gif"
    infoText: qsTr("Printhead is heating please wait.")
    animWidth: 351
    animHeight: 205
    fontPixelSize: 23

    property string gcodeToExecute: filamentWizardRoot.wizardType === FilamentWizard.WizardType.EmergencyUnloadAll
                                    ? 'M98 P"0:/sys/filachangload/unloadallwithheat.g"'
                                    : 'M98 "cleanprinthead.g"'

    footer {
        visible: false
        onNextClicked: {
            filamentWizardRoot.pushView("UnloadAll1.qml")
        }
        onVisibleChanged: {
            if (footer.visible) {
                if (filamentWizardRoot.wizardType === FilamentWizard.WizardType.CleanPrintHead) {
                    filesModel.saveCleanHeadTimestamp()
                }
            }
        }
    }

    Component.onCompleted: {
        printerModel.executeGcodeLine(gcodeToExecute)
    }

    Column {
        id: tempColumn
        spacing: 5
        anchors {
            right: parent.right
            top: parent.top
        }
        width: parent.width * 0.3

        KeyValueItem {
            width: parent.width
            keyText: qsTr("Print bed:")
            valueText: qsTr("%1/%2%3C").arg(printerModel.heatBedTemp).arg(printerModel.heatBedTargetTemp).arg(AppStyle.degreeSymbol)
        }

        KeyValueItem {
            width: parent.width
            keyText: qsTr("Printhead:")
            valueText: qsTr("%1/%2%3C").arg(printerModel.firstExtruderTemp).arg(printerModel.firstExtruderTargetTemp).arg(AppStyle.degreeSymbol)
        }
    }
}
