// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import QtQuick.Controls 2.4
import AppStyle 1.0

RadioButton {
    id: control
    text: "1"
    width: rootItem.width * 0.12
    height: rootItem.height * 0.43

    property string descText: ""
//    property int wizardType: FilamentWizard.WizardType.Load
    property bool locked: (filamentWizardRoot.wizardType === FilamentWizard.WizardType.Load && (control.descText === "" || control.checked))
    property color textColor: locked ? AppStyle.theme.textColor : "#858585"
    property real fontPixelSize: control.height * 0.3


    enabled: filamentWizardRoot.wizardType === FilamentWizard.WizardType.Load
             ? (descText.length === 0)
             : (descText.length > 0)

    indicator: Rectangle {
        color: "transparent"
        implicitWidth: 76
        implicitHeight: 76
    }

    contentItem: Item {
        implicitWidth: 76
        implicitHeight: 76
        Text {
            id: slotNumberText
            color: (control.checked ? AppStyle.theme.foreground : control.textColor)
            anchors.centerIn: parent
            width: parent.width * 0.9
            font.pixelSize: control.fontPixelSize
            layer.enabled: false
            font.weight: Font.Normal
            font.bold: control.checked || !locked
            wrapMode: Text.WordWrap
            horizontalAlignment: Text.AlignHCenter
            text: control.text
        }
        Text {
            color: (control.checked ? AppStyle.theme.foreground : control.textColor)
            anchors {
                top: slotNumberText.bottom
                horizontalCenter: parent.horizontalCenter
            }
            horizontalAlignment: Text.AlignHCenter
            width: parent.width * 0.9
            font.pixelSize: control.height * 0.06
            font.bold: true
            text: control.descText
            wrapMode: Text.WordWrap
        }
    }

    background: Rectangle {
        implicitWidth: 26
        implicitHeight: 26
        border.width: control.checked ? 8 : 2
        border.color: AppStyle.theme.foreground
        color: locked ? "transparent" : "#DDDDDD"
    }

}
