// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7

RowTextAnim {
    property string unloadSlotName: ""
    animSource: "gifs/filament-unload-" + unloadSlotName + "_final.gif"
    infoText: qsTr("Pull the filament through the hole and wind the material back on the spool properly. \n\n\nPlease perform the operation as fast as possible to keep the cabinet and filaments dry.")

    footer {
        visible: true
        nextBtnVisible: false
        backBtnText: "Main Menu"
        onBackClicked: {
            rootItem.back()
        }
    }
}
