// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import AppStyle 1.0
import AppControls 1.0
import AppViews 1.0

AbstactPage {
    id: unloadInfo
    property string selectedMaterial: "" //TODO: get current saved materail
    property string descriptionText: ""

    footer {
        nextBtnVisible: filamentWizardRoot.wizardType !== FilamentWizard.WizardType.Load
        onNextClicked: {
            filamentWizardRoot.pushView("HeatingInfo.qml", { "filamentName": selectedMaterial })
        }
        onBackClicked: {
            filamentWizardRoot.cancelWizard()
        }
    }

    Column {
        spacing: AppStyle.theme.defaultMargin
        anchors.centerIn: parent
        width: parent.width
        Text {
            id: infoTextItem
            text: descriptionText
            width: parent.width
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignHCenter
            font.pixelSize: 25
            wrapMode: Text.WordWrap
            color: AppStyle.theme.textColor
        }

        Item {
            width: parent.width
            height: filamentGrid.height

            Grid {
                id: filamentGrid
                anchors.centerIn: parent
                rows: parseInt(btnRepeater.model.length / 3) + 1
                columns: 3
                spacing: AppStyle.theme.defaultMargin

                Repeater {
                    id: btnRepeater
                    model: ["DYNAMIDE®-GF", "DYNAMIDE®-CF"]
                    TextButton {
                        text: modelData
                        textPixelSize: 22
                        defaultWidth: 180
                        onClicked: {
                            //TODO: update model property
                            selectedMaterial = modelData
                            filamentWizardRoot.saveLastMaterial(selectedMaterial)
                            filamentWizardRoot.pushView("HeatingInfo.qml", { "filamentName": selectedMaterial })
                        }
                    }
                }

                TextButton {
                    text: qsTr("Custom")
                    textPixelSize: 22
                    onClicked: {
                        filamentWizardRoot.pushView("TemperatureEnter.qml")
                    }
                }
            }
        }
    }
}
