// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import AppControls 1.0
import AppDialogs 1.0
import AppStyle 1.0
import AppViews 1.0
import "constants.js" as Constants

AbstactPage {
    id: networkMenu

    property real btnWidth: 200
    property real btnHeight: 160

    ConfirmDialog {
        id: confirmOfflineMode
        visible: false
        z: 50
        anchors {
            centerIn: parent
        }
        yesText: coreModel.offlineMode ? qsTr("Reconnect") : qsTr("Disconnect")
        noText: qsTr("Cancel")
        msg: coreModel.offlineMode ? qsTr("Are you sure that you want to reconnect to the Cloud?")
                                   : qsTr("Are you sure that you want to disconnect from the Cloud?")
        onYes: {
            //TODO: refactor and move this logic to model

            if (coreModel.offlineMode && !printerModel.gotAuthToken) {
                printerModel.disconnect_printer()
            }

            coreModel.toggleOfflineMode()

            if (printerModel.gotAuthToken) {
                rootItem.hideSetting()
                return
            }

            rootItem.hideSettingWithBusy()
        }
    }

    pageBody: Item {
        anchors.fill: parent

        Row {
            spacing: AppStyle.theme.defaultMargin * 0.6
            anchors.centerIn: parent

            TextButton {
                width: btnWidth
                height: btnHeight
                text: coreModel.offlineMode ? qsTr("Leave offline mode") : qsTr("Enter offline mode")
                onClicked: {
                    if (coreModel.offlineMode && (coreModel.state === Constants.States.PRINTING || coreModel.state === Constants.States.PAUSED)) {
                        rootItem.showMessageDialog(Constants.MessageTypes.INFO, qsTr("Please cancel the print before leave offline mode"), "OK")
                        return
                    }
                    confirmOfflineMode.visible = true
                }
            }

            TextButton {
                width: btnWidth
                height: btnHeight
                text: qsTr("Wi-Fi")
                onClicked: {
                    rootItem.pushView("SelectWifiView.qml")
                }
            }
        }
    }

    footer {
        nextBtnVisible: false
        visible: !confirmOfflineMode.visible
        onBackClicked: {
            rootItem.showHead()
            rootItem.back()
        }
    }
}
