import QtQuick 2.7
import QtQuick.Controls 2.4
import AppStyle 1.0
import AppViews 1.0

AbstactPage {

    signal updateLogReceived(string line)
    property bool osUpdateFinished: false
    onUpdateLogReceived: {
        if (line == "finished") {
            osUpdateFinished = true
        }
        updateOutputText.text += line + "\n"
    }

    Component.onCompleted: {
        coreModel.onOsUpdateLog.connect(updateLogReceived)
        coreModel.startOSUpdate()
    }

    Component.onDestruction: {
        coreModel.onOsUpdateLog.disconnect(updateLogReceived)
    }

    pageBody: Item {
        anchors.fill: parent

        ScrollView {
            id: updateOutScrollView
            anchors {
                fill: parent
                bottomMargin: AppStyle.defaultMargin * 0.5
            }

            ScrollBar.vertical: ScrollBar {
                id: scroll
                policy: ScrollBar.AlwaysOn
                visible: true
                parent: updateOutScrollView
                interactive: true
                position: 1
                anchors {
                    top: parent.top
                    left: parent.right
                    bottom: parent.bottom
                }

                contentItem: Rectangle {
                    implicitWidth: 7
                    implicitHeight: 100
                    color: scroll.pressed ? AppStyle.textColor : AppStyle.foreground
                }
            }

            TextArea {
                id: updateOutputText
                readOnly: true
                wrapMode: Text.WordWrap
                color: AppStyle.textColor
            }
        }
    }

    footer {
        height: rootItem.keyboardVisible() ? 0 : AppStyle.footerHeight
        nextBtnVisible: false
        backBtnVisible: osUpdateFinished
        onBackClicked: {
            rootItem.back()
        }
    }
}
