// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import AppViews 1.0

RowPage {
    id: glovesWarn
    animSource: "gifs/weargloves.gif"
    infoText: qsTr("Please wear protective gloves for your safety.")

    property string currentMaterial: "DYNAMIDE®-GF"
    function openFile(fileUrl) {
        var request = new XMLHttpRequest();
        request.open("GET", fileUrl, false);
        request.send(null);
        return request.responseText;
    }

    footer {
        visible: false
        onNextClicked: {
            switch(filamentWizardRoot.wizardType) {
            case FilamentWizard.WizardType.Load:
                filamentWizardRoot.pushView("FilamentSelect.qml",
                                            {"descriptionText": qsTr("Select the material to load:")})
                break;
            case FilamentWizard.WizardType.Unload:
            case FilamentWizard.WizardType.RemovePrinthead:
                //TODO: replace DYNAMIDE®-GF' with model property
                filamentWizardRoot.pushView("FilamentSelect.qml",
                                            {"descriptionText": qsTr("You are going to unload %1").arg(currentMaterial)})
                break;
            }
        }
    }

    Component.onCompleted: {
        currentMaterial = openFile("./currentMaterial")
//        filamentWizardRoot.startTestTimer() // comment me
        printerModel.executeGcodeLine('M98 P"centerhead.g"')

    }
}
