// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.0
import AppStyle 1.0

//TODO: add triangle img to logo
Rectangle {
    id: head
    width: AppStyle.rootItemWidth
    height: AppStyle.headHeight
    color: "black"

    property string headMsg: ""

    Image {
        id: logoImg
        anchors {
            left: parent.left
            leftMargin: head.height * 0.5
            verticalCenter: parent.verticalCenter
        }
        //        height: parent.height * 0.5
        asynchronous: true

        source: "img/logo_loop_3d.svg"
        sourceSize.height: 28
        sourceSize.width: 224
        onStatusChanged: {
            if (status === Image.Ready) {
                console.log("logo size: ", logoImg.paintedWidth, logoImg.paintedHeight)
            }
        }
    }

    Item {
        id: headMsgItem
        anchors {
            top: parent.top
            left: logoImg.right
            right: settingsRow.left
            bottom: parent.bottom
        }

        Text {
            id: headMsgText
            anchors.centerIn: parent
            text: headMsg
            color: AppStyle.textColor
            font.family: "Audiowide"
            font.pixelSize: parent.height * 0.4
        }
    }

    Row {
        id: settingsRow
        anchors {
            top: parent.top
            right: parent.right
            bottom: parent.bottom
            rightMargin: head.height * 0.5
        }
        clip: true
        spacing: 1

        Item {
            height: settingsRow.height
            width: AppStyle.headItemHeight

            Image {
                id: settingsIcon
                anchors.centerIn: parent
                source: rootItem.settingsOpened ? "img/cog-off.svg" : "img/cog.svg"
                asynchronous: true
            }

            MouseArea {
                anchors.fill: parent
                onClicked: {
                    rootItem.showSetting()
                }
            }
        }

        Item {
            height: settingsRow.height
            width: AppStyle.headItemHeight

            Image {
                id: wifiIcon
                asynchronous: true
                anchors.centerIn: parent

                function getWifiSignalImg() {
                    switch(networkModel.wifiSignal) {
                    case 0:
                        return "img/wifi-header-0.png"
                    case 1:
                        return "img/wifi-header-1.png"
                    case 2:
                        return "img/wifi-header-2.png"
                    case 3:
                        return "img/wifi-header-3.png"
                    case 4:
                        return "img/wifi-header-4.png"
                    }
                }

                source: networkModel.connectionIsWired ? "img/network_cable.svg" : getWifiSignalImg()
                sourceSize.width: AppStyle.headItemHeight
                sourceSize.height: AppStyle.headItemHeight
            }
        }
    }
}
