import QtQuick 2.7
import QtQuick.Controls 2.2

import AppStyle 1.0
import AppViews 1.0

AbstactPage {
    id: licenseItem
    property url filePath: ""

    pageBody: ScrollView {
        id: licenseScrollView
        anchors.fill: parent

        ScrollBar.vertical: ScrollBar {
            id: scroll
            policy: ScrollBar.AlwaysOn
            visible: true
            parent: licenseScrollView
            interactive: true
            anchors {
                top: parent.top
                left: parent.right
                bottom: parent.bottom
            }

            contentItem: Rectangle {
                implicitWidth: 7
                implicitHeight: 100
                color: scroll.pressed ? AppStyle.textColor : AppStyle.foreground
            }
        }

        TextArea {
            id: licenseText
            readOnly: true
            wrapMode: Text.WordWrap
            color: AppStyle.textColor
        }
    }

    function openFile(fileUrl) {
        var request = new XMLHttpRequest();
        request.open("GET", fileUrl, false);
        request.send(null);
        return request.responseText;
    }

    Component.onCompleted: {
        licenseText.text = openFile(licenseItem.filePath)
    }

    footer {
        nextBtnVisible: false
        onBackClicked: {
            rootItem.back()
        }
    }
}
