import QtQuick 2.7
import AppControls 1.0
import AppStyle 1.0

Rectangle {
    id: updateRect
    color: AppStyle.background
    z: 200
    Column {
        id: updateColumn
        anchors {
            left: parent.left
            right: parent.right
            centerIn: parent
        }
        spacing: 10

        AppBusyIndicator {
            width: Math.min(updateRect.width, updateRect.height) * 0.25
            height: Math.min(updateRect.width, updateRect.height) * 0.25
            running: true
        }

        Text {
            width: updateColumn.width
            color: AppStyle.textColor
            horizontalAlignment: Text.AlignHCenter
            font.pixelSize: 20
            text: qsTr("Downloading the update package, please wait.\nSystem will reboot after successful update.")
        }
    }

    MouseArea {
        anchors.fill: parent
    }

    Component.onCompleted: {
        rootItem.hideHead()
        rootItem.hideBusy()
    }
}
