# Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
# Built in San Francisco.

# This software is distributed under a commercial license for personal,
# educational, corporate or any other use.
# The software as a whole or any parts of it is prohibited for distribution or
# use without obtaining a license from 3D Control Systems, Inc.

# All software licenses are subject to the 3DPrinterOS terms of use
# (available at https://www.3dprinteros.com/terms-and-conditions/),
# and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import sys
import hashlib

import user_login

class DummyApp:
    pass

dummy_app = DummyApp()
dummy_app.stop_flag = False

if __name__ == '__main__':
    login_manager = user_login.UserLogin(app=dummy_app)
    if len(sys.argv) < 3:
        error = 'Two arguments required: login and password'
    else:
        password = hashlib.sha256(sys.argv[2].encode("utf-8")).hexdigest()
        error = login_manager.login_as_user(sys.argv[1], password)
    if error:
        print('Login failed! ' + str(error))
    else:
        print('Login successful: ' + sys.argv[1])
