// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import QtQuick.Controls 2.4
import AppStyle 1.0

ProgressBar {
    id: control
    height: 80
    width: 540
    value: 0.5
    padding: 2

    background: Rectangle {
        implicitWidth: 540
        implicitHeight: 68
        color: "transparent"
        border {
            width: 1
            color: AppStyle.foreground
        }
    }

    contentItem: Item {
        implicitWidth: 540
        implicitHeight: 68

        Rectangle {
            width: control.visualPosition * parent.width
            height: parent.height
            radius: 2
            color: AppStyle.foreground
        }
    }

    Text {
        id: percentText
        anchors {
            right: parent.right
            rightMargin: control.width * 0.07
            verticalCenter: parent.verticalCenter
        }
        font {
            family: "Audiowide"
            bold: true
            pixelSize: 35
        }
        color: "white"
        text: parseInt(control.value * 100) + "%"
        z: 20
    }
}
