// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.0
import QtQuick.Controls 2.4
import AppStyle 1.0

Button {
    id: control
    width: 200
    height: 160

    text: "Back"
    font.bold: true
    property color backgroundColor: AppStyle.foreground
    property string imgSrc: "../img/back-sub-icon.png"

    contentItem: Item {
        Image {
            id: img
            anchors {
                centerIn: parent
                verticalCenterOffset: -19
                horizontalCenterOffset: 4
            }
            sourceSize.width: 64
            sourceSize.height: 64
            asynchronous: true
            source: imgSrc
        }

        Text {
            text: control.text
            verticalAlignment: Text.AlignBottom
            horizontalAlignment: Text.AlignHCenter
            width: 40
            wrapMode: Text.WordWrap
            anchors {
                top: img.bottom
                topMargin: 37
                horizontalCenter: parent.horizontalCenter
                horizontalCenterOffset: 4
            }
            font {
                bold: true
                pixelSize: 20
            }
        }
    }

    background: Rectangle {
        height: 160
        implicitWidth: 200
        implicitHeight: 200
        border.width: 0
        color: control.pressed ? AppStyle.grey : control.backgroundColor
        Rectangle {
            x: 0
            y: 101
            anchors.bottom: parent.bottom
            color: "white"
            width: 200
            height: 40
        }
    }
}
