// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import QtQuick.Controls 2.4
import AppStyle 1.0

Button {
    id: control
    height: 59
    width: 323
    property string filamentName: "PLA+"
    property int temp: 215
    property bool selected: false
    contentItem: Item {
        id: item1
        Text {
            id: filamentNameText
            anchors {
                left: parent.left
                anchors.leftMargin: 10
            }
            font {
                bold: true
                pixelSize: 20
            }
            y: 12
            text: qsTr(filamentName)
            verticalAlignment: Text.AlignTop
            horizontalAlignment: Text.AlignLeft
        }

        Text {
            id: tempText
            anchors {
                right: parent.right
                verticalCenter: parent.verticalCenter
            }
            font {
                bold: true
                pixelSize: 20
            }
            text: temp + qsTr("C")
        }

        Text {
            id: checkedText
            anchors {
                horizontalCenterOffset: 53 // check symbol
                centerIn: parent
            }
            font {
                pixelSize: 40
                bold: true
            }
            color: AppStyle.green
            text: AppStyle.checkSymbol
            visible: control.selected
        }
    }

    background: Rectangle {
        implicitWidth: 323
        implicitHeight: 59
        border.width: 0
        color: AppStyle.orange
    }
}
