// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import QtQuick.Controls 2.4
import AppStyle 1.0

Button {
    id: control
    height: 76
    width: visible ? 184 : 0
    property color backgroundColor: AppStyle.foreground
    property color pressedColor: AppStyle.background
    property string imgSource: "../img/back-button-icon.png"
    contentItem: Item {
        Image {
            id: img
            anchors.centerIn: parent
            sourceSize.width: 64
            sourceSize.height: 64
            asynchronous: true
            source: imgSource
        }
    }

    background: Rectangle {
        implicitWidth: 184
        implicitHeight: 76
        border.width: 1
        border.color: AppStyle.foreground
        color: control.pressed ? pressedColor : backgroundColor
    }
}
