# Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
# Built in San Francisco.

# This software is distributed under a commercial license for personal,
# educational, corporate or any other use.
# The software as a whole or any parts of it is prohibited for distribution or
# use without obtaining a license from 3D Control Systems, Inc.

# All software licenses are subject to the 3DPrinterOS terms of use
# (available at https://www.3dprinteros.com/terms-and-conditions/),
# and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

from dual_cam import Camera


class MultiCamera(Camera):

    def search_cameras(self):
        self.indexes = []
        Camera.search_cameras(self)

    def init_capture(self, capture, index):
        Camera.init_capture(self, capture, index)
        self.indexes.append(index)
        capture.release()
        del(capture)

    def make_shot(self):
        number = self.active_camera_number
        try:
            capture = self.cv2.VideoCapture(self.indexes[number])
        except Exception as e:
            self.logger.warning("Error while opening video capture: " + str(e))
            self.fails[number] += 1
        else:
            if capture.isOpened():
                self.captures[number] = capture
                frame = Camera.make_shot(self)
                capture.release()
                del(capture)
                return frame


if __name__ == "__main__":
    MultiCamera()
