// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import QtQuick.Controls 2.4
import AppStyle 1.0

RadioButton {
    id: control
    text: "10"
    width: 76
    height: 76
    indicator: Rectangle {
        color: "transparent"
        implicitWidth: 76
        implicitHeight: 76


    }

    contentItem: Item {
        implicitWidth: 76
        implicitHeight: 76
        Text {
            color: AppStyle.textColor
            anchors.centerIn: parent
            font.pixelSize: control.height * 0.45
            text: control.text
        }
    }

    background: Rectangle {
        implicitWidth: 26
        implicitHeight: 26
        border.width: 1
        border.color: AppStyle.foreground
        color: control.checked ? AppStyle.foreground : "transparent"
    }

}
