// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import QtQuick.Layouts 1.13
import AppStyle 1.0
import AppControls 1.0

Row {
    id: joystickItem
    spacing: 10

    property var negativeBtnModel: ["-0.1", "-1", "-10", "-100"]
    property var positiveBtnModel: ["100", "10", "1", "0.1"]
    property var zBtnModel: ["100", "10", "1", "0.1", "-0.1", "-1", "-10", "-100"]

    property real btnTextPixelSize: btnHeight * 0.4
    property real btnWidth: 65
    property real btnHeight: 65

    signal xClicked(bool positive)
    signal yClicked(bool positive)
    signal zClicked(bool positive)


    Item {
        id: xyControlItem
        width: btnWidth * 3
        height: btnHeight * 3


        TextButton {
            id: leftBtn
            width: btnWidth
            height: btnHeight
            text: "-X"
            anchors {
                left: parent.left
                verticalCenter: parent.verticalCenter
            }

            onClicked: {
                xClicked(false)
            }
        }

        TextButton {
            id: rightBtn
            width: btnWidth
            height: btnHeight
            text: "+X"
            anchors {
                left: topBtn.right
                leftMargin: -1
                verticalCenter: parent.verticalCenter
            }

            onClicked: {
                xClicked(true)
            }
        }

        TextButton {
            id: bottomBtn
            width: btnWidth
            height: btnHeight
            text: "-Y"
            anchors {
                bottom: parent.bottom
                bottomMargin: 1
                left: leftBtn.right
                leftMargin: -1
            }
            onClicked: {
                yClicked(false)
            }
        }

        TextButton {
            id: topBtn
            width: btnWidth
            height: btnHeight
            text: "+Y"
            anchors {
                top: parent.top
                topMargin: 1
                left: leftBtn.right
                leftMargin: -1
            }
            onClicked: {
                yClicked(true)
            }
        }
    }

    Column {
        spacing: btnHeight

        TextButton {
            id: zPlusBtn
            width: btnWidth
            height: btnHeight
            text: "+Z"
            onClicked: {
                zClicked(true)
            }
        }

        TextButton {
            id: zMinusBtn
            width: btnWidth
            height: btnHeight
            text: "-Z"
            onClicked: {
                zClicked(false)
            }
        }
    }
}

