// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

pragma Singleton
import QtQuick 2.7

/*
    This file contains read only properties that could be repeated in many qml files
*/

Item {
    // symbols
    readonly property string degreeSymbol: "\u00B0"
    readonly property string checkSymbol: "\u2713"

    // colors
    readonly property color orange: "#ffb700"
    readonly property color red: "#ed0000"
    readonly property color greyBorder: "#d2d2d2"
    readonly property color greyLine: "#b5b5b5"
    readonly property color grey: "#ebebeb"
    readonly property color greyText: "#4d4d4d"
    readonly property color green: "#5bd11c"
    readonly property color background: "#222026"
    readonly property color foreground: "#31AFFD"
    readonly property color textColor: "white"

    // sizes
    readonly property real rootItemWidth: 800.0
    readonly property real rootItemHeight: 480.0
    readonly property real headHeight: 60.0
    readonly property real headLogoWidth: 83.0
    readonly property real headItemHeight: 45.0
    readonly property real headItemStatusTextWidth: 55.0
    readonly property real footerHeight: 76.0
    readonly property real defaultMargin: 50.0
    readonly property real textFieldHeight: 64.0
    readonly property real settingsMenuItemWidth: 160.0
    readonly property real settingsMenuItemHeight: 128.0

}
