// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import AppStyle 1.0
import AppViews 1.0

AbstactPage {
    property string filamentName: ""
    property real customTemp: 0

    footer {
        visible: false
        nextBtnVisible: false
        backBtnVisible: false
        onVisibleChanged: {
            if (footer.visible) {
                filamentWizardRoot.pushView("LoadInfo4.qml")
            }
        }
    }

    Component.onCompleted: {
//        filamentWizardRoot.startTestTimer() // comment me
        printerModel.executeGcodeLine('M98 P"loadfilament.g"')
    }

    pageBody: Column {
        width: parent.width
        spacing: AppStyle.defaultMargin
        anchors.centerIn: parent

        Text {
            id: infoTextItem
            text: qsTr("Loading the filament, please wait...")
            width: parent.width
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignHCenter
            font.pixelSize: 25
            wrapMode: Text.WordWrap
            color: AppStyle.textColor
        }

        Item {
            id: imgWrapper
            width: parent.width
            height: gif.height

            AnimatedImage {
                id: gif
                anchors.centerIn: parent
                source: "gifs/waiting.gif"
            }
        }
    }
}
