// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import QtQuick.Controls 2.4
import AppControls 1.0
import AppStyle 1.0
import AppViews 1.0

import "constants.js" as Constants

AbstactPage {
    id: wifiPasswdView

    property string ssid: "Local Network Demo"
    property bool secured: true

    BusyLayer {
        id: wifiPasswdBusyLayer
        anchors.centerIn: parent
        z: passwdItem.z + 1
        MouseArea {
            anchors.fill: parent
        }
    }

    Connections {
        target: rootItem
        onKeyPressed: {
            if (key === '\b') {
                passwdField.remove(passwdField.cursorPosition - 1, passwdField.cursorPosition)
                return
            }
            passwdField.insert(passwdField.cursorPosition, key)
        }
        onEnterPressed: {
            passwdField.focus = false
            rootItem.hideKeyboard()
        }
    }

    Connections {
        target: networkModel
        onOn_connectError: {
            errorArea.errorString = networkModel.connectError
        }
    }

    Timer {
        id: hideHeadTimer
        interval: 250
        repeat: false
        onTriggered: rootItem.hideHead()
    }

    Component.onCompleted: {
        hideHeadTimer.start()
    }

    footer {
        visible: !rootItem.keyboardItem.visible
        height: rootItem.keyboardItem.visible ? 0 : AppStyle.footerHeight

        textInfo: qsTr("")
        nextBtnText: qsTr("Connect")
        nextBtnVisible: true

        onBackClicked: {
            rootItem.setHeadMsg(qsTr("Settings"))
            rootItem.showHead()
            rootItem.back()
        }

        onNextClicked: {
            errorArea.errorString = ""
            wifiPasswdBusyLayer.show()
            if (coreModel.offlineMode)
                coreModel.toggleOfflineMode()
            networkModel.connectWifi(ssid, passwdField.text)
        }
    }

    pageBody: Item {
        id: passwdItem
        anchors.fill: parent
        Item {
            id: wrapper
            anchors {
                top: parent.top
                left: parent.left
                right: parent.right
                bottom: parent.bottom
                rightMargin: 30
                leftMargin: 30
            }

            Item {
                id: ssidInfo
                height: 64
                anchors {
                    top: parent.top
                    left: parent.left
                    right: parent.right
                }

                Text {
                    id: ssidLabel
                    color: "white"
                    anchors {
                        left: parent.left
                        verticalCenter: parent.verticalCenter
                    }
                    font.pixelSize: 32
                    text: ssid
                }
            }

            TextField {
                id: passwdField
                height: 64
                anchors {
                    top: ssidInfo.bottom
                    left: parent.left
                    right: parent.right
                }
                visible: secured
                font.pixelSize: passwdField.height * 0.5
                echoMode: passwdCheckBox.checked ? TextInput.Normal : TextInput.Password
                placeholderText: qsTr("enter password")
                onPressed: {
                    rootItem.showKeyboard()
                    focus = true
                }

            }

            CheckBox {
                id: passwdCheckBox
                anchors {
                    top: passwdField.bottom
                    left: parent.left
                }
                visible: passwdField.visible
                checked: false
                contentItem: Text {
                    text: passwdCheckBox.text
                    font: passwdCheckBox.font
                    opacity: enabled ? 1.0 : 0.3
                    color: AppStyle.textColor
                    //                      color: control.down ? "#17a81a" : "#21be2b"
                    verticalAlignment: Text.AlignVCenter
                    leftPadding: passwdCheckBox.indicator.width + passwdCheckBox.spacing
                }
                text: qsTr("Show password")
            }

            Rectangle {
                id: errorArea
                height: errorString !== "" ? 50 : 0
                anchors {
                    left: parent.left
                    right: parent.right
                    bottom: parent.bottom
                    bottomMargin: 2
                }
                visible: errorString !== ""
                color: AppStyle.red

                property string errorString: ""

                onErrorStringChanged: {
                    wifiPasswdBusyLayer.hide()
                }

                Text {
                    id: errorText
                    anchors.centerIn: parent
                    text: errorArea.errorString
                    font {
                        pixelSize: parent.height * 0.5
                        italic: true
                    }
                }

                Behavior on height { PropertyAnimation { duration: 250 } }
            }
        }
    }
}

