# Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
# Built in San Francisco.

# This software is distributed under a commercial license for personal,
# educational, corporate or any other use.
# The software as a whole or any parts of it is prohibited for distribution or
# use without obtaining a license from 3D Control Systems, Inc.

# All software licenses are subject to the 3DPrinterOS terms of use
# (available at https://www.3dprinteros.com/terms-and-conditions/),
# and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

class WizardFormer:

    STAGES = ('greetings', 'connect_printer', 'choose_printer_type', 'choose_live_view_mode', 'tray_icon',
                     'more_features', 'rename_printer', 'printer_workgroups', 'cloud_sync',
                     'restore_default_settings', 'report_problem', 'final')

    def __init__(self, page_former):
        self.page_former = page_former
        self.server = self.page_former.server
        self.current_stage = self.STAGES[0]

    def place_scripts_on_connecting_printer_page(self, page_content):
        scripts = self.page_former.get_script_to_refresh_element('printers_info', 'wizard/get_printers_info_without_controls',
                                                     error_message='No connection to 3DPrinterOS Client<br />'
                                                                   'Most likely it was closed'), \
                  self.server.web_content_files['templates']['scripts']['mousedown_script.js']
        return self.page_former.place_scripts_on_page(page_content, *scripts)

    def place_scripts_on_choosing_printer_type_page(self, page_content):
        scripts = self.page_former.get_script_to_refresh_element('printers_info', 'wizard/get_printers_info_with_type_button',
                                                     error_message='No connection to 3DPrinterOS Client<br />'
                                                                   'Most likely it was closed'), \
                  self.server.web_content_files['templates']['scripts']['mousedown_script.js']
        return self.page_former.place_scripts_on_page(page_content, *scripts)

    def place_scripts_on_printer_workgroups_page(self, page_content):
        scripts = self.page_former.get_script_to_refresh_element('printers_info', 'wizard/get_printers_info_with_workgroups_button',
                                                     error_message='No connection to 3DPrinterOS Client<br />'
                                                                   'Most likely it was closed'), \
                  self.server.web_content_files['templates']['scripts']['mousedown_script.js']
        return self.page_former.place_scripts_on_page(page_content, *scripts)

    def place_scripts_on_rename_printer_page(self, page_content):
        scripts = self.page_former.get_script_to_refresh_element('printers_info', 'wizard/get_printers_info_with_rename_button',
                                                     error_message='No connection to 3DPrinterOS Client<br />'
                                                                   'Most likely it was closed'), \
                  self.server.web_content_files['templates']['scripts']['mousedown_script.js']
        return self.page_former.place_scripts_on_page(page_content, *scripts)

    def get_current_page(self):
        if self.current_stage == self.STAGES[0]:
            return self.form_greetings_page()
        elif self.current_stage == self.STAGES[1]:
            return self.form_connect_printer_page()
        elif self.current_stage == self.STAGES[2]:
            return self.form_choose_printer_type_page()
        elif self.current_stage == self.STAGES[3]:
            return self.form_choose_live_view_mode_page()
        elif self.current_stage == self.STAGES[4]:
            return self.form_tray_icon_page()
        elif self.current_stage == self.STAGES[5]:
            return self.form_more_features_page()
        elif self.current_stage == self.STAGES[6]:
            return self.form_rename_printer_page()
        elif self.current_stage == self.STAGES[7]:
            return self.form_printer_workgroups_page()
        elif self.current_stage == self.STAGES[8]:
            return self.form_cloud_sync_page()
        elif self.current_stage == self.STAGES[9]:
            return self.form_restore_default_settings_page()
        elif self.current_stage == self.STAGES[10]:
            return self.form_report_problem_page()
        elif self.current_stage == self.STAGES[11]:
            return self.form_final_page()

    def form_page(self, body, next_title, next_path, return_title, return_path, return_value='Previous',
                  return_options='', next_value='Next', next_options=''):
        page = self.server.web_content_files['templates']['wizard']['base.html']
        page = page.replace('!!!BODY!!!', body)
        page = page.replace('!!!NEXT_TITLE!!!', next_title)
        page = page.replace('!!!NEXT_PATH!!!', next_path)
        page = page.replace('!!!NEXT_VALUE!!!', next_value)
        page = page.replace('!!!NEXT_OPTIONS!!!', next_options)
        page = page.replace('!!!RETURN_TITLE!!!', return_title)
        page = page.replace('!!!RETURN_VALUE!!!', return_value)
        page = page.replace('!!!RETURN_PATH!!!', return_path)
        page = page.replace('!!!RETURN_OPTIONS!!!', return_options)
        return page

    def form_greetings_page(self):
        page = self.server.web_content_files['templates']['wizard']['greetings.html']
        return self.form_page(page, next_title='Connecting printer', next_path='wizard/connect_printer',
                                    return_title='Skip tutorial', return_path='close_wizard',
                                    return_value='Skip', return_options='style="background:#ff9900"')

    def form_connect_printer_page(self):
        page = self.server.web_content_files['templates']['wizard']['connect_printer.html']
        page = self.page_former.place_virtual_printer_button(page)
        page = self.form_page(body=page, next_title='Choose printer type', next_path='wizard/choose_printer_type',
                                     return_title='Greetings', return_path='wizard/greetings')
        return self.place_scripts_on_connecting_printer_page(page)

    def form_choose_printer_type_page(self):
        page = self.server.web_content_files['templates']['wizard']['choose_printer_type.html']
        page = self.form_page(body=page, next_title='Choose live view mode', next_path='wizard/choose_live_view_mode',
                                     return_title='Connect printer', return_path='wizard/connect_printer')
        return self.place_scripts_on_choosing_printer_type_page(page)

    def form_choose_live_view_mode_page(self):
        page = self.server.web_content_files['templates']['wizard']['choose_live_view_mode.html']
        page = page.replace('!!!MODE_SELECT!!!', self.page_former.form_camera_mode_selector())
        return self.form_page(body=page, next_title='Tray icon', next_path='wizard/tray_icon',
                                     return_title='Choose printer type', return_path='wizard/choose_printer_type')

    def form_tray_icon_page(self):
        page = self.server.web_content_files['templates']['wizard']['tray_icon.html']
        return self.form_page(body=page, next_title='Discover more features', next_path='wizard/more_features',
                                     return_title='Choose live view mode', return_path='wizard/choose_live_view_mode')

    def form_more_features_page(self):
        page = self.server.web_content_files['templates']['wizard']['more_features.html']
        return self.form_page(body=page, next_title='Rename printer', next_path='wizard/rename_printer',
                                     return_title='Tray icon setup', return_path='wizard/tray_icon')

    def form_rename_printer_page(self):
        page = self.server.web_content_files['templates']['wizard']['rename_printer.html']
        page = self.form_page(body=page, next_title='Printer workgroups', next_path='wizard/printer_workgroups',
                                     return_title='Discover more features', return_path='wizard/more_features')
        return self.place_scripts_on_rename_printer_page(page)

    def form_printer_workgroups_page(self):
        page = self.server.web_content_files['templates']['wizard']['printer_workgroups.html']
        page = self.form_page(body=page, next_title='CloudSync', next_path='wizard/cloud_sync',
                                     return_title='Rename printer', return_path='wizard/rename_printer')
        return self.place_scripts_on_printer_workgroups_page(page)

    def form_cloud_sync_page(self):
        page = self.server.web_content_files['templates']['wizard']['cloud_sync.html']
        page = self.page_former.place_cloudsync_buttons(page)
        return self.form_page(body=page, next_title='Restore default settings',
                                     next_path='wizard/restore_default_settings',
                                     return_title='Printer workgroups', return_path='wizard/printer_workgroups')

    def form_restore_default_settings_page(self):
        page = self.server.web_content_files['templates']['wizard']['restore_default_settings.html']
        return self.form_page(body=page, next_title='Report problem',
                                     next_path='wizard/report_problem',
                                     return_title='CloudSync', return_path='wizard/cloud_sync')

    def form_report_problem_page(self):
        page = self.server.web_content_files['templates']['wizard']['report_problem.html']
        return self.form_page(body=page, next_title='Final',
                              next_path='wizard/final',
                              return_title='Restore default settings',
                              return_path='wizard/restore_default_settings')

    def form_final_page(self):
        page = self.server.web_content_files['templates']['wizard']['final.html']
        return self.form_page(body=page, next_title='Start work', next_value='Complete',
                              next_path='wizard/close_wizard', next_options='style="background: #ff9900"',
                              return_title='Report problem',
                              return_path='wizard/report_problem')
