// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import AppControls 1.0
import AppDialogs 1.0
import AppStyle 1.0
import AppViews 1.0

import "constants.js" as Constants

AbstactPage {
    id: accountInfoView

    pageBody: Item {
        anchors.fill: parent

        Column {
            id: aboutColumn
            width: parent.width
            spacing: 10
            anchors.centerIn: parent

            Text {
                id: versionLabel
                width: aboutColumn.width
                horizontalAlignment: Text.AlignHCenter
                color: "white"
                text: qsTr("Version: " + coreModel.version)
                font {
                    bold: true
                    pixelSize: 35
                }

                MouseArea {
                    anchors.fill: parent
                    property int clickCount: 0
                    onClicked: {
                        clickCount++
                        if (clickCount > 9) {
                            clickCount = 0
                            rootItem.pushView("HidenMenu.qml")
                        }
                    }
                }
            }

            Text {
                id: ipLabel
                width: aboutColumn.width
                horizontalAlignment: Text.AlignHCenter
                color: "white"
                text: qsTr("Local IP: " + networkModel.localIp)
                font {
                    bold: true
                    pixelSize: 35
                }
            }

            Item {
                id: licensesBtnWraper
                width: aboutColumn.width
                height: licensesBtn.height
                TextButton {
                    id: licensesBtn
                    anchors.centerIn: parent
                    width: 300
                    text: "Open Source Licences"
                    onClicked: {
                        rootItem.pushView("LicensesList.qml")
                    }
                }
            }
        }
    }

    footer {
        nextBtnVisible: false
        onBackClicked: {
            rootItem.showHead()
            rootItem.back()
        }
    }
}
