// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7

RowPage {
    id: unloadInfo
    animSource: "gifs/pullthefilament.gif"
    infoText: qsTr("Hold the tip of the filament and pull it downwards until the filament is released completely. When done press 'Next'.")
    footer {
        visible: false
        onNextClicked: {
            filamentWizardRoot.pushView("UnloadInfo5.qml")
        }
    }

    Component.onCompleted: {
//        filamentWizardRoot.startTestTimer() // comment me
        printerModel.executeGcodeLine('M98 P"primetocut.g"')
    }


}
