// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import QtQuick.Controls 2.4
import AppStyle 1.0

Slider {
    id: control
    value: 50
    height: 68
    width: 540
    from: 0
    to: 100

    stepSize: 5

    background: Rectangle {
        color: "transparent"
        implicitHeight: 68
        implicitWidth: 540
        Image {
            id: upRawImg
            asynchronous: true
            anchors {
                top: parent.top
                right: parent.right
                left: parent.left
            }
            source: "../img/grid.png"
        }

        Rectangle {
            x: control.leftPadding
            y: control.topPadding + control.availableHeight / 2 - height / 2
            implicitWidth: 200
            implicitHeight: 4
            width: control.availableWidth
            height: implicitHeight
            color: AppStyle.red

            Rectangle {
                width: control.visualPosition * parent.width
                height: parent.height
                color: AppStyle.orange
                radius: 2
            }
        }

        Image {
            id: downRawImg
            asynchronous: true
            anchors {
                right: parent.right
                left: parent.left
                bottom: parent.bottom
            }
            source: "../img/grid.png"
        }
    }

    handle: Item {
        x: control.leftPadding + control.visualPosition * (control.availableWidth - width)
        y: control.topPadding + control.availableHeight / 2 - height / 2
        implicitWidth: 68
        implicitHeight: 100
        Image {
            id: handleImg
            asynchronous: true
            source: "../img/slider.png"
            sourceSize.width: 68
            sourceSize.height: 100
        }
    }
}
