// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import AppStyle 1.0
import AppControls 1.0
import AppViews 1.0

AbstactPage {
    footer {
        visible: false
        nextBtnVisible: false
        backBtnVisible: false
        height: 0
    }

    Component.onCompleted: {
//        filamentWizardRoot.startTestTimer() //for tests
        printerModel.executeGcodeLine('M98 P"primetocut.g"')
    }

    Column {
        width: parent.width
        spacing: AppStyle.defaultMargin * 0.25
        anchors.centerIn: parent
        Item {
            id: imgWrapper
            width: parent.width
            height: gifsRow.height
            Row {
                id: gifsRow
                anchors.centerIn: parent
                spacing: AppStyle.defaultMargin
                Item {
                    width: gif.width
                    height: Math.max(gif.height, gif2.height)
                    AnimatedImage {
                        id: gif
                        anchors.centerIn: parent
                        source: "gifs/exposethefilamentandcut.gif"
                    }
                }

                Item {
                    width: gif2.width
                    height: Math.max(gif.height, gif2.height)
                    AnimatedImage {
                        id: gif2
                        anchors.centerIn: parent
                        source: "gifs/placehead.gif"
                    }
                }
            }
        }

        Text {
            id: infoTextItem
            text: qsTr("Please cut the tip of the filament with a side cutter before inserting the printhead. When you are ready, insert the printhead and rotate the printhead leverclockwise until the printheadis tightly fixed then press 'Finish'.")
            width: parent.width
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignHCenter
            font.pixelSize: 25
            wrapMode: Text.WordWrap
            color: AppStyle.textColor
        }

        Item {
            width: parent.width
            height: finishBtn.height
            TextButton {
                id: finishBtn
                visible: footer.visible
                anchors.centerIn: parent
                text: qsTr("Finish")
                onClicked: {
                    printerModel.executeGcodeLine('M98 P"finish.g"')
                    printerModel.executeGcodeLine('M108')
                    rootItem.hideSetting()
                }
            }
        }
    }
}
