// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import AppControls 1.0
import AppStyle 1.0
import AppViews 1.0

import "constants.js" as Constants

AbstactPage {
    readonly property string cloudSwitchTarget: coreModel.cloudURL.split('.')[0] === "cloud"
                                                ? "acorn" : "cloud"
    pageBody: Item {
        anchors.fill: parent

        Grid {
            id: menuGrid
            spacing: AppStyle.defaultMargin * 0.6
            anchors.centerIn: parent
            rows: 3
            columns: 3
            columnSpacing: AppStyle.defaultMargin * 0.6
            rowSpacing: AppStyle.defaultMargin * 0.6

            property real btnWidth: AppStyle.settingsMenuItemWidth
            property real btnHeight: AppStyle.settingsMenuItemHeight

            TextButton {
                width: menuGrid.btnWidth
                height: menuGrid.btnHeight
                text: qsTr("Switch to %1 and reboot").arg(cloudSwitchTarget)
                onClicked: {
                    coreModel.switchCloud()
                }
            }

            TextButton {
                width: menuGrid.btnWidth
                height: menuGrid.btnHeight
                text: coreModel.sshState ? qsTr("Disable SSH") : qsTr("Enable SSH")
                onClicked: {
                    coreModel.toggleSSH()
                }
            }

            TextButton {
                width: menuGrid.btnWidth
                height: menuGrid.btnHeight
                text: coreModel.virtualPrinterState ? qsTr("Disable virtual printer") : qsTr("Enable virtual printer")
                onClicked: {
                    coreModel.toggleVirtualPrinter()
                }
            }

            TextButton {
                width: menuGrid.btnWidth
                height: menuGrid.btnHeight
                text: qsTr("Edit config")
                onClicked: {
                    rootItem.pushView("ConfigEditView.qml")
                }
            }

            TextButton {
                width: menuGrid.btnWidth
                height: menuGrid.btnHeight
                text: qsTr("GCode Console")
                onClicked: {
                    if (coreModel.state === Constants.States.PRINTING || coreModel.state === Constants.States.PAUSED) {
                        rootItem.showMessageDialog(Constants.MessageTypes.INFO, qsTr("Can't enter gcode console while printing"), "OK")
                        return
                    }

                    if (coreModel.state === Constants.States.REGISTRATION) {
                        rootItem.showMessageDialog(Constants.MessageTypes.INFO, qsTr("Can't enter gcode console while in registeration mode"), "OK")
                        return
                    }

                    if (coreModel.state === Constants.States.CONNECTING) {
                        return
                    }

                    rootItem.pushView("GCodeConsole.qml")
                }
            }

            TextButton {
                width: menuGrid.btnWidth
                height: menuGrid.btnHeight
                text: qsTr("From USB")
                onClicked: {
                    rootItem.pushView("HidenFromUSB.qml")
                }
            }
        }
    }

    footer {
        nextBtnVisible: false
        onBackClicked: {
            rootItem.back()
        }
    }
}
