// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import AppControls 1.0
import AppStyle 1.0
import AppViews 1.0

AbstactPage {
    footer {
        visible: false
        nextBtnVisible: false
        backBtnVisible: false
    }
    pageBody: Column {
        width: parent.width
        anchors.centerIn: parent
        spacing: AppStyle.defaultMargin

        Component.onCompleted: {
            printerModel.executeGcodeLine('M98 P"finish.g"')
            printerModel.executeGcodeLine('M108')
        }

        Item {
            width: parent.width
            height: info.height
            Text {
                id: info
                text: qsTr("Pick the excess material from the tip of the nozzle with a tweezer and press the 'Finish' button when done.")
                width: parent.width * 0.6
                anchors.centerIn: parent
                verticalAlignment: Text.AlignVCenter
                horizontalAlignment: Text.AlignHCenter
                font.pixelSize: 25
                wrapMode: Text.WordWrap
                color: AppStyle.textColor
            }
        }

        Item {
            width: parent.width
            height: finishBtn.height
            TextButton {
                id: finishBtn
                anchors.centerIn: parent
                visible: footer.visible
                text: qsTr("Finish")
                onClicked: {
                    rootItem.hideSetting()
                }
            }
        }
    }
}
