// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import AppViews 1.0

RowPage {
    id: unloadInfo
    animSource: "gifs/windspool.gif"
    property string operationName: filamentWizardRoot.wizardType === FilamentWizard.WizardType.RemovePrinthead
                                   ? "Remove printhead"
                                   : "Unload"
    infoText: qsTr("%1 operation is successfully completed, please wind the remaining filament back to it’s spool and fix it by using the holes on the sides of the spool to prevent unwinding.").arg(operationName)

    footer {
        nextBtnText: qsTr("Load Filament")
        backBtnText: qsTr("Main menu")
        onNextClicked: {
            filamentWizardRoot.wizardType = FilamentWizard.WizardType.Load
            filamentWizardRoot.pushView("GlovesWarningView.qml")
        }
        onBackClicked: {
            rootItem.hideSetting()
        }
    }
    Component.onCompleted: {
        printerModel.executeGcodeLine('M98 P"finish.g"')
        printerModel.executeGcodeLine('M108')
    }
}
