// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.7
import AppStyle 1.0

Rectangle {
    id: helloScreen
    width: AppStyle.rootItemWidth
    height: AppStyle.rootItemHeight

    color: AppStyle.background

    property int currentAnim: anims.showHello
    property int animDuration: 1500

    QtObject {
        id: anims
        readonly property int showHello: 0
        readonly property int hideHello: 1
        readonly property int showGetStarted: 2
        readonly property int showBottomInfo: 3
        readonly property int hideAll: 4
    }

    Timer {
        id: animTimer
        interval: animDuration + 1000
        repeat: false
        running: true
        onTriggered: {
            switch (currentAnim) {
            case anims.showHello:
               helloLabel.stateVisible = true
               currentAnim = anims.hideHello
               animTimer.start()
               return
            case anims.hideHello:
               helloLabel.stateVisible = false
               currentAnim = anims.showGetStarted
               animTimer.start()
               return
            case anims.showGetStarted:
               helloLabel.text = qsTr("Lets get started!")
               helloLabel.anchors.verticalCenterOffset = -52
               helloLabel.stateVisible = true
               currentAnim = anims.showBottomInfo
               animTimer.start()
               return
            case anims.showBottomInfo:
               bottomLabel.stateVisible = true
               currentAnim = anims.hideAll
               animTimer.start()
               return
            case anims.hideAll:
               hideAll.start()
               return
            }
        }
    }

    NumberAnimation {
        id: hideAll
        target: helloScreen
        property: "opacity"
        from: 1.00
        to:  0.00
        duration: animDuration
        onStopped: {
            helloScreen.visible = false
        }
    }

    Text {
        id: helloLabel
        anchors.centerIn: parent
        text: qsTr("Hello!")
        color: AppStyle.textColor
        opacity: 0.0
        font {
            pixelSize: 57
            bold: true
        }

        property bool stateVisible: false

        states: [
            State { when: helloLabel.stateVisible;
                PropertyChanges { target: helloLabel; opacity: 1.0 }},
            State { when: !helloLabel.stateVisible;
                PropertyChanges { target: helloLabel; opacity: 0.0 }}
        ]
        transitions: [
            Transition {
                NumberAnimation { property: "opacity"; duration: animDuration }
            }
        ]
    }

    Text {
        id: bottomLabel
        width: 375
        anchors {
            top: helloLabel.bottom
            topMargin: 72
            horizontalCenter: parent.horizontalCenter
        }

        wrapMode: Text.WordWrap
        horizontalAlignment: Text.AlignHCenter
        text: qsTr("This is only Beta DEMO, so please don't judge harshly ;-)")
        color: AppStyle.textColor
        opacity: 0.0
        font {
            pixelSize: 24
        }

        property bool stateVisible: false

        states: [
            State { when: bottomLabel.stateVisible;
                PropertyChanges { target: bottomLabel; opacity: 1.0 }},
            State { when: !bottomLabel.stateVisible;
                PropertyChanges { target: bottomLabel; opacity: 0.0 }}
        ]
        transitions: [
            Transition {
                NumberAnimation { property: "opacity"; duration: animDuration }
            }
        ]
    }

    MouseArea {
        anchors.fill: parent
    }
}
