// Copyright 3D Control Systems, Inc. All Rights Reserved 2017-2019.
// Built in San Francisco.

// This software is distributed under a commercial license for personal,
// educational, corporate or any other use.
// The software as a whole or any parts of it is prohibited for distribution or
// use without obtaining a license from 3D Control Systems, Inc.

// All software licenses are subject to the 3DPrinterOS terms of use
// (available at https://www.3dprinteros.com/terms-and-conditions/),
// and privacy policy (available at https://www.3dprinteros.com/privacy-policy/)

import QtQuick 2.0

Rectangle {
    id: root
    // TODO: inherit keyboardItem instead of agregation

    property alias source: keyboardItem.source
    property alias keyWidth: keyboardItem.keyWidth
    property alias keyHeight: keyboardItem.keyHeight
    property alias bounds: keyboardItem.bounds
    property alias mainFont: keyboardItem.mainFont
    property alias mainFontColor: keyboardItem.mainFontColor
    property alias secondaryFont: keyboardItem.secondaryFont
    property alias secondaryFontColor: keyboardItem.secondaryFontColor
    property alias keyColor: keyboardItem.keyColor
    property alias keyPressedColor: keyboardItem.keyPressedColor

    signal enterClicked()
    signal hideClicked()
    signal keyClicked(string key)

    color: "black"
    width: 1024
    height: 640
    
    MouseArea {
        anchors.fill: parent
    }

    KeyboardItem {
        id: keyboardItem
        anchors.centerIn: parent
        source: "keyboard_us.xml"
        onKeyClicked: {
            root.keyClicked(key)
        }

        onEnterClicked: {
            root.enterClicked()
        }

        onHideClicked: {
            root.hideClicked()
        }

        onSwitchSource: root.source = source
    }
}

