from __future__ import absolute_import
import re
import warnings

from .BundleProcessor import BundleProcessor
from .LineTransformProcessor import LineTransformProcessor
from .RpmProcessor import RpmProcessor
from .CoordinateRemovalProcessor import CoordinateRemovalProcessor
from .AbpProcessor import AbpProcessor
from .ProgressProcessor import ProgressProcessor

import makerbot_driver


class SlicerProcessor(BundleProcessor):

    def __init__(self):
        super(SlicerProcessor, self).__init__()
        self.version = '0.9.3'
        self.processors = [
            RpmProcessor(),
            CoordinateRemovalProcessor(),
            AbpProcessor(),
            SlicerVersionChecker(self.version)
        ]


class SlicerVersionChecker(LineTransformProcessor):

    def __init__(self, version):
        super(SlicerVersionChecker, self).__init__()
        self.is_bundleable = True
        self.version = version
        tform = {
            re.compile(".*generated by Slic3r ([0-9]\.[0-9]\.[0-9])"):
            self._transform_check_version
        }
        if not self.code_map:
            self.code_map = {}
        self.code_map.update(tform)

    def _transform_check_version(self, match):
        if not match.group(1) == self.version:
            warnings.warn("Processing incompatible version of Slicer, resulting file may not be compatible with Makerbot_Driver", UserWarning)
        return match.string
