import QtQuick 2.0
import QtQuick.Controls 2.2

import AppStyle 1.0

/*
    Number TextField
    properties minValue, maxValue:
        if value out of range update TextField values

*/

TextField {
    id: control
    placeholderText: "_"
    height: AppStyle.textFieldHeight
    horizontalAlignment: Text.AlignHCenter
    font.pixelSize: height * 0.5
    validator: RegExpValidator {
        regExp: /^\d+\.?\d$/
    }

    property real minValue: 1.0
    property real maxValue: 1000.0
    property int maxDigits: 1
    signal validated(real numValue)

    background: Rectangle {
        implicitWidth: 50
        implicitHeight: 50
    }

    function validateField() {
        var numValue = parseFloat(control.text);
        if (numValue) {
            control.text = numValue < minValue
                    ? minValue : (numValue > maxValue
                                  ? maxValue : numValue)
            validated(numValue)
            return
        }
        control.text = ""
    }

    Connections {
        target: rootItem
        onEnterPressed: {
            control.validateField()
            rootItem.hideKeyboard()
        }
        onKeyPressed: {
            if (key === '\b') {
                control.remove(control.cursorPosition - 1, control.cursorPosition)
                return
            }
            control.insert(control.cursorPosition, key)
        }
    }
}


